<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ApiController;

Route::get('/', function () {
    return view('welcome');
});

// Register
Route::post('/register', [ApiController::class, 'register']);

// Other API Routes
Route::get('/banners/{lang?}', [ApiController::class, 'banners']);
Route::get('/pujaServices', [ApiController::class, 'getAllPooja']);
Route::get('/pujaServices1', [ApiController::class, 'getAllPooja1']);
Route::post('/getUserDetailsByEmailId', [ApiController::class, 'getUserDetailsByEmailId']);

// Login and Register
Route::post('/userregister', [ApiController::class, 'userRegister']);
Route::post('/login', [ApiController::class, 'login']);

// Country, State, City
Route::get('/countries', [ApiController::class, 'getCountries']);
Route::post('/states', [ApiController::class, 'getStatesByCountryId']);
Route::post('/cities', [ApiController::class, 'getCitiesByStateId']);

// Puja Services
Route::post('/pujaAddToCart', [ApiController::class, 'pujaAddToCart']);
Route::post('/pujaBooking', [ApiController::class, 'poojaBooking']);
Route::post('/userDetailsById', [ApiController::class, 'userDetailsById']);
Route::post('/pujaPayment', [ApiController::class, 'PoojaPayment']);
Route::post('/getByPujaServiceId', [ApiController::class, 'getByPujaServiceId']);
Route::post('/cartDetailsById', [ApiController::class, 'cartDetailsById']);
Route::post('/poojaCommonData', [ApiController::class, 'poojaCommonData']);
Route::post('/fetchDataBygId', [ApiController::class, 'fetchDataBygId']);
Route::post('/removePuja', [ApiController::class, 'removePuja']);

// Puja Cart
Route::post('/PujaGetCartData', [ApiController::class, 'PujaGetCartData']);
Route::post('/PujaitemRemove', [ApiController::class, 'pujaItemRemove']);
Route::post('/PujaGetCartDataByUserId', [ApiController::class, 'PujaGetCartDataByUserId']);
Route::post('/pujaPayments', [ApiController::class, 'PujaPayments']);
Route::post('/PujaDataAfterPayment', [ApiController::class, 'PujaDataAfterPayment']);

// Kitchen
Route::get('/getAllkitchen', [ApiController::class, 'getAllkitchen']);
Route::post('/getkitchenById', [ApiController::class, 'getkitchenById']);
Route::post('/kitchenAddToCart', [ApiController::class, 'kitchenAddToCart']);
Route::post('/kitchenGetCartData', [ApiController::class, 'kitchenGetCartData']);
Route::post('/itemRemove', [ApiController::class, 'itemRemove']);
Route::post('/kitchenGetCartDataByUserId', [ApiController::class, 'kitchenGetCartDataByUserId']);
Route::post('/kitchenPayments', [ApiController::class, 'kitchenPayments']);
Route::post('/kitchenDataAfterPayment', [ApiController::class, 'kitchenDataAfterPayment']);

// Events
Route::get('/Events', [ApiController::class, 'getAllEvent']);
Route::post('/eventBooking', [ApiController::class, 'eventBooking']);
Route::post('/eventPayments', [ApiController::class, 'eventPayments']);
Route::post('/getEventById', [ApiController::class, 'getEventById']);
Route::post('/eventCommonData', [ApiController::class, 'eventCommonData']);
Route::post('/fetchEventDataBygId', [ApiController::class, 'fetchEventDataBygId']);
Route::post('/removeEvent', [ApiController::class, 'removeEvent']);

// Event Cart
Route::post('/EventAddToCart', [ApiController::class, 'EventAddToCart']);
Route::post('/EventGetCartData', [ApiController::class, 'EventGetCartData']);
Route::post('/EventItemRemove', [ApiController::class, 'EventItemRemove']);
Route::post('/eventGetCartDataByUserId', [ApiController::class, 'eventGetCartDataByUserId']);
Route::post('/EventsPayment', [ApiController::class, 'EventsPayment']);
Route::post('/EventDataAfterPayment', [ApiController::class, 'EventDataAfterPayment']);

// Other Routes
Route::get('/getAlltempdetails', [ApiController::class, 'getAlltempdetails']);
Route::get('/photoGallery', [ApiController::class, 'photoGallery']);

// Priest Routes
Route::get('/getAllPrist', [ApiController::class, 'getAllPrist']);
Route::get('/getAllPristDetails', [ApiController::class, 'getAllPristDetails']);
Route::post('/getAllPristDetailsById', [ApiController::class, 'getAllPristDetailsById']);
Route::get('/templeClosingStatus', [ApiController::class, 'templeClosingStatus']);
